/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.datasource.GenericObject;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.attachment.Attachment;
import de.willuhn.jameica.attachment.Context;
import de.willuhn.jameica.attachment.storage.StorageProvider;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.messaging.MessageBus;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.services.ArchiveService;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AttachmentService
implements Bootable {
    private Map<String, StorageProvider> providers = new HashMap<String, StorageProvider>();
    public static final String QUEUE_DELETED = "jameica.attachment.deleted";
    public static final String QUEUE_ADDED = "jameica.attachment.added";
    public static final String QUEUE_UPDATE = "jameica.attachment.update";

    public Class<Bootable>[] depends() {
        return new Class[]{ArchiveService.class, BeanService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        Logger.info((String)"init attachment service");
        BeanService bs = (BeanService)loader.getBootable(BeanService.class);
        Logger.info((String)"searching available storage providers");
        try {
            for (Class c : Application.getClassLoader().getClassFinder().findImplementors(StorageProvider.class)) {
                try {
                    StorageProvider sp = (StorageProvider)bs.get(c);
                    Logger.info((String)("  [" + sp.getId() + "] " + sp.getName() + ": " + sp.isEnabled()));
                    if (!sp.isEnabled()) continue;
                    this.providers.put(sp.getId(), sp);
                }
                catch (Throwable t) {
                    Logger.error((String)("failed to load " + c), (Throwable)t);
                }
            }
        }
        catch (ClassNotFoundException cne) {
            Logger.error((String)"suspect - no storage providers found", (Throwable)cne);
        }
        Logger.info((String)("found storage providers: " + this.providers.size()));
    }

    public Context getContext() throws IOException {
        AbstractView view = GUI.getCurrentView();
        Object o = view.getCurrentObject();
        Plugin plugin = Application.getPluginLoader().findByClass(view.getClass());
        Context ctx = new Context();
        if (o instanceof GenericObject) {
            GenericObject g = (GenericObject)o;
            ctx.setClassName(g.getClass().getName());
            ctx.setId(g.getID());
        } else {
            ctx.setClassName(view.getClass().getName());
        }
        ctx.setPlugin(plugin != null ? plugin.getManifest().getPluginClass() : null);
        return ctx;
    }

    public List<Attachment> find() throws IOException {
        Context ctx = this.getContext();
        LinkedList<Attachment> result = new LinkedList<Attachment>();
        for (StorageProvider p : this.providers.values()) {
            result.addAll(p.getAttachments(ctx));
        }
        Collections.sort(result, (a1, a2) -> a1.getFilename().compareTo(a2.getFilename()));
        return result;
    }

    public void delete(Attachment a) throws IOException {
        StorageProvider provider = this.getProvider(a);
        if (provider == null) {
            throw new IOException("storage provider unknown for attachment " + a.getFilename());
        }
        Logger.info((String)("deleting attachment " + a.getFilename()));
        provider.delete(a);
        MessageBus.send(QUEUE_DELETED, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment add(File file, String storageId) throws IOException {
        Attachment attachment;
        if (!file.isFile() || !file.canRead()) {
            throw new IOException("file " + file + " not readable");
        }
        StorageProvider storage = this.providers.get(storageId);
        if (storage == null) {
            throw new IOException("storage provider unknown: " + storageId);
        }
        Context ctx = this.getContext();
        Attachment a = new Attachment();
        a.setContext(ctx);
        a.setFilename(file.getName());
        a.setStorageId(storageId);
        a.setDate(System.currentTimeMillis());
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            storage.create(a, is);
            Logger.info((String)("attachment created " + a.getFilename()));
            MessageBus.send(QUEUE_ADDED, a);
            attachment = a;
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{is});
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment update(Attachment a, File file) throws IOException {
        Attachment attachment;
        if (!file.isFile() || !file.canRead()) {
            throw new IOException("file " + file + " not readable");
        }
        StorageProvider storage = this.providers.get(a.getStorageId());
        if (storage == null) {
            throw new IOException("storage provider unknown: " + a.getStorageId());
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            storage.update(a, is);
            Logger.info((String)("attachment overwritten " + a.getFilename()));
            a.setDate(System.currentTimeMillis());
            MessageBus.send(QUEUE_UPDATE, a);
            attachment = a;
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{is});
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Attachment a, File file) throws IOException {
        StorageProvider provider = this.getProvider(a);
        if (provider == null) {
            throw new IOException("storage provider unknown for attachment " + a.getFilename());
        }
        Logger.info((String)("save attachment to " + file));
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            provider.copy(a, os);
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{os});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{os});
    }

    public StorageProvider getProvider(Attachment a) throws IOException {
        if (a == null || a.getStorageId() == null) {
            throw new IOException("storage provider unknown for attachment");
        }
        return this.getProvider(a.getStorageId());
    }

    public StorageProvider getProvider(String storageId) {
        return this.providers.get(storageId);
    }

    public List<StorageProvider> getProviders() {
        return Arrays.asList(this.providers.values().toArray(new StorageProvider[this.providers.size()]));
    }

    public void shutdown() {
        this.providers.clear();
    }
}

